import type { SecretLintCoreConfig, SecretLintCoreResult, SecretLintRawSource, SecretLintRuleLocaleTag } from "@secretlint/types";
export type SecretLintSourceOptions = {
    /**
     * Lint target source
     */
    source: SecretLintRawSource;
    options: {
        /**
         * local for translate
         * Default: "en"
         */
        locale?: SecretLintRuleLocaleTag;
        /**
         * If this is true, mask all message's data values
         * Replace data value with "****" strings
         * Default: false
         */
        maskSecrets?: boolean;
        /**
         * config present secretlintrc object
         */
        config: SecretLintCoreConfig;
    };
};
export declare const lintSource: ({ source, options }: SecretLintSourceOptions) => Promise<SecretLintCoreResult>;
//# sourceMappingURL=index.d.ts.map